#!/usr/bin/env node

const packageJson = require('./package');
const fs = require('fs');

const EXIT_FAIL = 1;
const EXIT_SUCCESS = 0;

// noinspection JSAnnotator
const usage = `
Usage: packageBuild artifact-name version
`;


function updatePackage(name, version) {
    return Object.assign({}, packageJson, {
        'artifact-name': name,
        'version': version,
    });
}


function writeFile(updatedPackage) {
    // Two space indentation
    const indentationLevel = '  ';
    const jsonString = JSON.stringify(updatedPackage, null, indentationLevel);
    fs.writeFileSync('./package.json', jsonString);

}


if (require.main === module) {
    // noinspection JSAnnotator
    const artifactName = process.argv[2];
    const packageNumber = process.argv[3];
    if (!(artifactName && packageNumber)) {
        console.log(usage);
        process.exit(EXIT_FAIL);
    } else {
        const json = updatePackage(artifactName, packageNumber);
        writeFile(json);
        process.exit(EXIT_SUCCESS);
    }
}